var cacheName = "module-traitements-v1";
var fontFiles = [
  "santor_1.002_2-webfont.woff",
  "santor_1.002_2-webfont.woff2",
  "SourceSansPro-Bold.woff",
  "SourceSansPro-Bold.woff2",
  "SourceSansPro-Light.woff",
  "SourceSansPro-Light.woff2",
  "sourcesanspro-regular-webfont.woff",
  "sourcesanspro-regular-webfont.woff2",
];


var appShellFiles = [
  "index.js",
  "css/index.css",
  "assets/audios/clic.mp3",
  "assets/audios/gagne.mp3",
  "assets/audios/perdu.mp3",
  "assets/audios/priseObjet.mp3",
  "assets/audios/bip_caisse.mp3",
  "assets/audios/book_page_turn.mp3",
  "assets/audios/caisse_enregistreuse.mp3",
  "assets/audios/double_bip_caisse.mp3",
  "assets/audios/magic_decouverte.mp3",

  "assets/images/desktop/fond.jpg",
  "assets/images/logo_pop.png",
  "assets/images/bt_legal.svg",
  "assets/images/logo.svg",
  "assets/images/bt_suivant.png",
  "assets/images/bt_full_screen.svg",
  "assets/images/novo-nordisk-blc.svg",
  "assets/images/croix_rond.svg",
  "assets/images/logo_novo.png",

  "assets/game_6/alpha.png",
  "assets/game_6/biguanides.png",
  "assets/game_6/coche_bleu.png",
  "assets/game_6/croix_rond.svg",
  "assets/game_6/glinides.png",
  "assets/game_6/glp.png",
  "assets/game_6/idpp.png",
  "assets/game_6/insuline.png",
  "assets/game_6/isglt.png",
  "assets/game_6/sulfamides.png",
  
  "/index.html",
   ...fontFiles.map((i) => "fonts/" + i),
];

const contentToCache = appShellFiles;

// Installing Service Worker
self.addEventListener("install", (e) => {
  console.log("[Service Worker] Install");
  e.waitUntil(
    (async () => {
      const cache = await caches.open(cacheName);
      console.log("[Service Worker] Caching all: app shell and content");
      await cache.addAll(contentToCache);
    })()
  );
});

// Fetching content using Service Worker
self.addEventListener("fetch", (e) => {
  // Cache http and https only, skip unsupported chrome-extension:// and file://...
  if (
    !(e.request.url.startsWith("http:") || e.request.url.startsWith("https:"))
  ) {
    return;
  }

  e.respondWith(
    (async () => {
      const r = await caches.match(e.request);
      console.log(`[Service Worker] Fetching resource: ${e.request.url}`);
      if (r) return r;
      const response = await fetch(e.request);
      const cache = await caches.open(cacheName);
      console.log(`[Service Worker] Caching new resource: ${e.request.url}`);
      cache.put(e.request, response.clone());
      return response;
    })()
  );
});
